(* Uzywanie delegatow w SML.NET *)
structure Demo = struct 
fun main () = 
    let
	open Classes

	(* Tworzenie obiektu delegata Task *)
	val task = Task(fn () => print "\ninvoked!")
	val _ = task.#Invoke()
	

	(* Teraz tworzymy pare zadan *)
        val tasks = List.map (fn s => Task (fn () => (print "\n";print s))) ["a","b","c"]
 
        (* Dodajemy je do TaskList *)
	val _ = List.app TaskList.AddTask tasks

	(* Deklaracja typu delegata *)

	_classtype BinaryOp of (int * int) -> int

	val plus = BinaryOp (op +)  
	val times = BinaryOp (op * ) 

        fun fold (delegate : BinaryOp, id, list) = List.foldr (delegate.#Invoke) id list

        val 10 = fold(plus, 0, [1, 2, 3, 4])
	val 24 = fold(times, 1, [1, 2, 3, 4])

    in  (* Wywolanie polaczonych delegatow *)
	TaskList.DoTasks();
        (* Wywolanie oryginalnego delegata *)
	task.#Invoke();
	print "\ndone!" 
    end 
end
